/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.api.capability.food.CapabilityFood;
import net.dries007.tfc.api.capability.food.IFood;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketStackFood
implements IMessage {
    private int slotNumber;

    @Deprecated
    public PacketStackFood() {
    }

    public PacketStackFood(int slotNumber) {
        this.slotNumber = slotNumber;
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.slotNumber = byteBuf.readInt();
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeInt(this.slotNumber);
    }

    public static final class Handler
    implements IMessageHandler<PacketStackFood, IMessage> {
        public IMessage onMessage(PacketStackFood message, MessageContext ctx) {
            TerraFirmaCraft.getProxy().getThreadListener(ctx).func_152344_a(() -> {
                EntityPlayer player = TerraFirmaCraft.getProxy().getPlayer(ctx);
                if (player != null) {
                    if (!(player.field_71070_bA instanceof ContainerPlayer) || message.slotNumber < 0 || message.slotNumber >= player.field_71070_bA.field_75151_b.size()) {
                        return;
                    }
                    Slot targetSlot = player.field_71070_bA.func_75139_a(message.slotNumber);
                    ItemStack targetStack = targetSlot.func_75211_c();
                    IFood targetCap = (IFood)targetStack.getCapability(CapabilityFood.CAPABILITY, null);
                    if (targetCap == null || targetStack.func_77976_d() == targetStack.func_190916_E() || targetCap.isRotten()) {
                        return;
                    }
                    List<Slot> stackableSlots = this.getStackableSlots(targetSlot, player.field_71070_bA.field_75151_b);
                    int currentAmount = targetStack.func_190916_E();
                    int remaining = targetStack.func_77976_d() - currentAmount;
                    long minCreationDate = targetCap.getCreationDate();
                    Iterator<Slot> slotIterator = stackableSlots.iterator();
                    while (remaining > 0 && slotIterator.hasNext()) {
                        Slot slot = slotIterator.next();
                        ItemStack stack = slot.func_75211_c();
                        IFood cap = (IFood)stack.getCapability(CapabilityFood.CAPABILITY, null);
                        if (cap == null || cap.isRotten()) continue;
                        if (cap.getCreationDate() < minCreationDate) {
                            minCreationDate = cap.getCreationDate();
                        }
                        if (remaining < stack.func_190916_E()) {
                            currentAmount += remaining;
                            stack.func_190918_g(remaining);
                            remaining = 0;
                            continue;
                        }
                        currentAmount += stack.func_190916_E();
                        remaining -= stack.func_190916_E();
                        stack.func_190918_g(stack.func_190916_E());
                    }
                    targetStack.func_190920_e(currentAmount);
                    targetCap.setCreationDate(minCreationDate);
                    player.field_71070_bA.func_75130_a((IInventory)((ContainerPlayer)player.field_71070_bA).field_75181_e);
                }
            });
            return null;
        }

        private List<Slot> getStackableSlots(Slot targetSlot, List<Slot> inventorySlots) {
            ArrayList<Slot> stackableSlots = new ArrayList<Slot>();
            for (Slot slot2 : inventorySlots) {
                if (slot2.getSlotIndex() == targetSlot.getSlotIndex() || slot2 instanceof SlotCrafting) continue;
                ItemStack stack = slot2.func_75211_c();
                if (!CapabilityFood.areStacksStackableExceptCreationDate(targetSlot.func_75211_c(), stack)) continue;
                stackableSlots.add(slot2);
            }
            stackableSlots.sort(Comparator.comparingInt(slot -> slot.func_75211_c().func_190916_E()));
            return stackableSlots;
        }
    }
}

